﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.Security.AntiXss;

public partial class controls_BioLabResultUserControl : System.Web.UI.UserControl
{
    private bool _LabReportDateIsReadOnly;

    protected void Page_Load(object sender, EventArgs e)
    {
        RangeValidatorForlblReportDate.MaximumValue = 
            RangeValidatorForSpecimenCollectionDate.MaximumValue = 
                DateTime.Today.AddYears(100).ToShortDateString();

    }

    /// <summary>
    /// Determines if Lab Report Date field is a read only label or an editable text box
    /// </summary>
    public bool LabReportDateIsReadOnly
    {
        set
        {
            if (value == true)
            {
                TextBoxReportDate.Visible = false;
                lblReportDate.Visible = true;
                LabelReportDateLabel.Text = LabelReportDateLabel.Text.Replace(" (mm/dd/yyyy)", "");
                LabelReportDateLabel.SkinID = "Datalabel";
                LabelReportDateLabel.AssociatedControlID = lblReportDate.ID;
            }
            else
            {
                TextBoxReportDate.Visible = true;
                lblReportDate.Visible = false;
                LabelReportDateLabel.SkinID = "Datalabel";
            }

            _LabReportDateIsReadOnly = value;
        }
    }
   

    public void SetfieldValues(PatientLabInfo info, bool linkPatientWorkflows)
    {
        ChangeHistoryUserControl.WorkFlowCalseId = info.WorkFlowCaseId;
        ChangeHistoryUserControl.ControlWidth = PanelPatient.Width;

        if (linkPatientWorkflows)
        {            
            patientWorkflowsLink.Text = info.Name;
            patientWorkflowsLink.NavigateUrl = String.Format("~/PatientWorkflows.aspx?patientId={0}", info.ID);            
            lblFullName.Visible = false;
            patientWorkflowsLink.Visible = true;
            LabelforFullNameLabel.AssociatedControlID = patientWorkflowsLink.ID;
        }
        else
        {
            lblFullName.Text = info.Name;
            lblFullName.Visible = true;
            patientWorkflowsLink.Visible = false;
            LabelforFullNameLabel.AssociatedControlID = lblFullName.ID;
        }

        lblReportDate.Text = info.ReportDate;
        TextBoxReportDate.Text = info.ReportDate;  
        lblICN.Text = info.ICN;
        lblSnum.Text = info.Snum;
        lblGender.Text = info.Gender;
        lblBirthday.Text = info.BirthDate;
        lblPostalCode.Text = info.PostalCode;
        //lblLabContact.Text = info.LabContact;
        txtLabContact.Text = AntiXssEncoder.HtmlEncode(info.LabContact ?? "Dr. Brown", false);
        //lblAccession.Text = info.Accession;
        //lblAccession1.Text = info.Accession1;
        
        txtAccession.Text = info.Accession;
        lblLabName.Text = AntiXssEncoder.HtmlEncode(info.LabName, false);
        //lblSpecimenCollnDt.Text = info.SpecColnDate;
        TextBoxSpecimenCollectionDate.Text = info.SpecColnDate;

        var kitReceivedDate = AntiXssEncoder.HtmlEncode(info.KitReceivedDate, false);
        lblKitReceivedDate.Text = kitReceivedDate;
        KitReceivedDateHiddenBox.Text = kitReceivedDate;
    }

    public void GetfieldValues(PatientLabInfo info)
    {
        if (lblFullName.Visible)
            info.Name = lblFullName.Text.Trim();
        else
            info.Name = patientWorkflowsLink.Text.Trim();
        
        info.ReportDate = lblReportDate.Text;
        //info.ReportDate = txtReportDate.Text.Trim(); 
        if (!_LabReportDateIsReadOnly)
        {
            info.ReportDate = TextBoxReportDate.Text;  
        }

        info.ICN = lblICN.Text;
        info.Snum = lblSnum.Text;
        info.Gender = lblGender.Text;
        info.PostalCode = lblPostalCode.Text;
        info.BirthDate = lblBirthday.Text; 
        info.LabContact = txtLabContact.Text.Trim();
        info.SpecColnDate = TextBoxSpecimenCollectionDate.Text;
        info.LabName = lblLabName.Text;
        info.Accession = txtAccession.Text.Trim(); 
    }
}
    public class PatientLabInfo
    {
        public string Name { get; set; }
        public string ID { get; set; }
        public string ReportDate { get; set; }
        public string ICN { get; set; }
        public string Snum { get; set; }
        public string Gender { get; set; }
        public string BirthDate { get; set; }
        public string LabContact { get; set; }
        public string Accession { get; set; }
        public string Accession1 { get; set; }
        public string LabName { get; set; }
        public string SpecColnDate { get; set; }
        public string KitReceivedDate { get; set; }
        public string PostalCode { get; set; }
        public string WorkFlowCaseId { get; set; }
    }
